/*
 * Decompiled with CFR 0.152.
 */
package aeonics.data;

import aeonics.data.Data;
import aeonics.util.Exportable;
import aeonics.util.Json;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;

public class DataObject
implements Data {
    private Object source = null;

    public DataObject(Object object) {
        this.source = object;
    }

    @Override
    public Iterator<Data> iterator() {
        return Collections.singleton(this).iterator();
    }

    @Override
    public Iterable<Map.Entry<String, Data>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isBool() {
        return this.source instanceof Boolean;
    }

    @Override
    public boolean isNumber() {
        return this.source instanceof Number;
    }

    @Override
    public boolean isString() {
        return this.source instanceof String;
    }

    @Override
    public boolean isNull() {
        return this.source == null;
    }

    @Override
    public boolean is(Class<?> clazz) {
        return clazz.isInstance(this.source);
    }

    @Override
    public boolean isEmpty() {
        return this.isNull() || this.source instanceof String && ((String)this.source).isBlank();
    }

    @Override
    public Data get(String string) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public Data get(int n) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public <T> T get() {
        return (T)this.source;
    }

    @Override
    public boolean containsKey(String string) {
        return false;
    }

    @Override
    public void clear() {
        this.source = null;
    }

    @Override
    public int size() {
        return this.isString() ? ((String)this.source).length() : 1;
    }

    @Override
    public Data remove(String string) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public Data remove(int n) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public Data remove(Data data) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public void removeIf(Predicate<Data> predicate) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public Data add(Object object) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public Data add(Object ... objectArray) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public Data put(String string, Object object) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public Data set(int n, Object object) {
        throw new RuntimeException("This element is not a container");
    }

    @Override
    public Data set(Object object) {
        this.source = object instanceof Data ? ((Data)object).get() : object;
        return this;
    }

    @Override
    public boolean asBool() {
        if (this.source == null) {
            return false;
        }
        try {
            return (Boolean)this.source;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            if (this.source instanceof String && (((String)this.source).equalsIgnoreCase("true") || ((String)this.source).equalsIgnoreCase("yes"))) {
                return true;
            }
            return this.asNumber().doubleValue() > 0.0;
        }
    }

    @Override
    public Number asNumber() {
        if (this.source == null) {
            return 0;
        }
        try {
            return (Number)this.source;
        }
        catch (ClassCastException classCastException) {
            if (this.source instanceof Boolean) {
                return (Boolean)this.source != false ? 1 : 0;
            }
            try {
                return Long.parseLong(this.source.toString());
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(this.source.toString());
                }
                catch (NumberFormatException numberFormatException2) {
                    if (!(this.source instanceof String)) {
                        return this.source.hashCode();
                    }
                    return 0;
                }
            }
        }
    }

    @Override
    public String asString() {
        if (this.source == null) {
            return "";
        }
        return this.source.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        if (this.source == null) {
            stringBuilder.append("null");
        } else if (this.source instanceof Number) {
            if (((Number)this.source).doubleValue() == (double)((Number)this.source).longValue()) {
                stringBuilder.append(((Number)this.source).longValue());
            } else {
                stringBuilder.append(((Number)this.source).doubleValue());
            }
        } else if (this.source instanceof Boolean) {
            stringBuilder.append((Boolean)this.source != false ? "true" : "false");
        } else if (this.source instanceof Exportable) {
            stringBuilder.append(((Exportable)this.source).export().toString());
        } else {
            stringBuilder.append("\"");
            stringBuilder.append(Json.escape(this.asString()));
            stringBuilder.append("\"");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Data) {
            object = ((Data)object).get();
        }
        if (object == this.source) {
            return true;
        }
        if (object == null || this.source == null) {
            return false;
        }
        if (object instanceof String) {
            return this.asString().equals(object);
        }
        if (object instanceof Boolean) {
            return this.asBool() == ((Boolean)object).booleanValue();
        }
        if (object instanceof Number) {
            return this.asNumber().equals(object);
        }
        return object.equals(this.source);
    }

    @Override
    public Data clone() {
        DataObject dataObject = new DataObject(null);
        this.cloneTo(dataObject);
        return dataObject;
    }

    @Override
    public void cloneTo(Data data) {
        if (!(data instanceof DataObject)) {
            throw new IllegalArgumentException("Clone failed. Incompatible receiving data type.");
        }
        ((DataObject)data).source = this.source;
    }
}

