/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.entity.Message;
import aeonics.entity.Step;
import aeonics.manager.Executor;
import aeonics.manager.Manager;
import aeonics.template.Channel;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.Hardware;
import aeonics.util.Tuples;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class Queue
extends Step.Action {
    @Override
    protected Class<? extends Type> defaultTarget() {
        return Type.class;
    }

    @Override
    protected Supplier<? extends Type> defaultCreator() {
        return Type::new;
    }

    @Override
    public Step.Template template() {
        return (Step.Template)((Template)((Template)((Template)((Template)((Template)((Template)((Template)((Step.Template)((Step.Template)((Step.Template)super.template().icon("stacks")).role(Step.ROLE.QUEUE)).input((Channel)((Channel)new Channel("data").summary("Data")).description("Enqueue a message."))).output((Channel)((Channel)new Channel("data").summary("Data")).description("Dequeued messages."))).summary("Queue")).description("The queue will buffer messages in memory and process them according to the configured parameters.")).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("limit").summary("Maximum number of queued messages")).description("This parameter defines the maximum number of messages that can be queued. If the limit is reached, additional messages will be rejected. To disable the limit, set it to a negative value. If the limit is set to 0, then it means there will not be any queuing and the messages will be processed directly as they arrive.")).rule(Parameter.Rule.INTEGER).format("number")).defaultValue(-1))).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("concurrency").summary("Concurrency level")).description("The concurrency level defines how many messages can be processed simultaneously. In order to ensure messages are processed sequentially, set this parameter to 1. The value 0 or a negative value means that there is no limit to the number of concurrent processing. In a way, this means that there is no queuing because all messages are sent for processing immediately. The default value is the number of processors on the machine.")).rule(Parameter.Rule.DIGIT).format("number")).defaultValue(Hardware.CPU.limit()))).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("priority").summary("High priority")).description("Whether or not this queue should execute in high priority mode.")).rule(Parameter.Rule.BOOLEAN).format("boolean")).defaultValue(false))).onCreate((data, type) -> {
            ((Type)type).concurrency = type.valueOf("concurrency").asInt();
            ((Type)type).limit = type.valueOf("limit").asInt();
        })).onUpdate((data, type) -> {
            ((Type)type).concurrency = type.valueOf("concurrency").asInt();
            ((Type)type).limit = type.valueOf("limit").asInt();
        });
    }

    public static class Type
    extends Step.Action.Type {
        private int concurrency = 0;
        private int limit = 0;
        private Deque<Tuples.Tuple<Message, Executor.Task<Void>>> queue = new ConcurrentLinkedDeque<Tuples.Tuple<Message, Executor.Task<Void>>>();
        private AtomicInteger parallel = new AtomicInteger(0);

        @Override
        Executor.Task<Void> acceptAction(Message message, String string) {
            if (this.concurrency <= 0) {
                return super.acceptAction(message, string);
            }
            Tuples.Tuple tuple = Tuples.Tuple.of(message, Manager.of(Executor.class).normalPending());
            if (this.limit > 0 && this.queue.size() >= this.limit) {
                message.metadata().put("error", new IllegalStateException("Queue size exceeded"));
                return this.emit(message, "error");
            }
            this.queue.offer(tuple);
            while (this.checkNext()) {
            }
            return (Executor.Task)tuple.b;
        }

        private boolean checkNext() {
            int n;
            do {
                n = this.parallel.get();
                if (this.concurrency <= 0 || n < this.concurrency) continue;
                return false;
            } while (!this.parallel.compareAndSet(n, n + 1));
            Tuples.Tuple<Message, Executor.Task<Void>> tuple = this.queue.poll();
            if (tuple == null) {
                this.parallel.decrementAndGet();
                return false;
            }
            this.emit((Message)tuple.a, "data").anyway(() -> {
                this.parallel.decrementAndGet();
                ((Executor.Task)tuple.b).complete(null);
                while (this.checkNext()) {
                }
            });
            return true;
        }
    }
}

