/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity.security;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.Registry;
import aeonics.entity.security.Rule;
import aeonics.entity.security.User;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Security;
import aeonics.manager.Vault;
import aeonics.template.Factory;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.Json;
import aeonics.util.StringUtils;
import java.math.BigDecimal;
import java.util.function.Supplier;

public abstract class Provider
extends Item<Type> {
    @Override
    public Template<? extends Type> template() {
        return ((Template)super.template().add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("active").summary("Active")).description("Whether or not this provider is active")).rule(Parameter.Rule.BOOLEAN).format("boolean")).optional(true).defaultValue(true))).onCreate((data, type) -> {
            type.key = data.containsKey("key") ? data.asString("key") : Manager.of(Security.class).randomHash();
        });
    }

    @Override
    protected Class<? extends Provider> category() {
        return Provider.class;
    }

    public static class Local
    extends Provider {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends aeonics.entity.security.Provider$Type> template() {
            return ((Template)((Template)super.template().summary("Local identity provider")).description("This identity provider uses a password authentication scheme. The context data should contain the 'username' and 'password' properties.")).add(((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("complexity").summary("Password policy complexity")).description("Enforce the password complexity to be above the specified threshold of possible combinations.")).defaultValue(10000000000000000L)).format("number")).rule(Parameter.Rule.DIGIT));
        }

        public static class Type
        extends aeonics.entity.security.Provider$Type {
            @Override
            public boolean supports(String string) {
                if (string == null) {
                    return false;
                }
                User.Type type2 = (User.Type)Registry.of(User.class).get(type -> string.equals(type.login()));
                if (type2 == null) {
                    return false;
                }
                Data data = this.privateData(type2);
                return !data.isEmpty();
            }

            @Override
            public User.Type authenticate(Data data) {
                if (!(data != null && data.isMap() && data.containsKey("username") && data.containsKey("password"))) {
                    return null;
                }
                User.Type type2 = (User.Type)Registry.of(User.class).get(type -> data.asString("username").equals(type.login()));
                if (type2 == null) {
                    return null;
                }
                Data data2 = this.privateData(type2);
                if (data2.isEmpty()) {
                    return null;
                }
                String string = Manager.of(Security.class).hash(data.asString("password"), data2.asString("salt"));
                if (string.equals(data2.asString("password"))) {
                    return type2;
                }
                return null;
            }

            @Override
            public synchronized User.Type join(Data data, User.Type type2) {
                User.Type type3;
                if (data == null || !data.isMap() || !data.containsKey("username")) {
                    return null;
                }
                Data data2 = Data.map().put("password", null).put("salt", null);
                if (data.containsKey("password")) {
                    long l = this.complexity(data.asString("password"));
                    if (l < this.valueOf("complexity").asLong()) {
                        Manager.of(Logger.class).warning(this.getClass(), (Object)"Password complexity requirement not met");
                        return null;
                    }
                    data2.put("salt", Manager.of(Security.class).randomHash());
                    data2.put("password", Manager.of(Security.class).hash(data.asString("password"), data2.asString("salt")));
                } else if (data.containsKey("hash") && data.containsKey("salt")) {
                    data2.put("salt", data.get("salt"));
                    data2.put("password", data.get("hash"));
                }
                if (type2 == null && (type3 = (User.Type)Registry.of(User.class).get(type -> data.asString("username").equals(type.login()))) != null) {
                    type2 = type3;
                }
                if (type2 == null) {
                    type2 = (User.Type)((User.Type)Factory.of(User.class).get(User.class).create(Data.map().put("parameters", Data.map().put("login", data.asString("username")).put("active", true)))).name(data.asString("username"));
                }
                if (!this.privateData(type2).isEmpty()) {
                    return type2;
                }
                this.privateData(type2, data2);
                return type2;
            }

            @Override
            public synchronized void leave(User.Type type) {
                if (type == null) {
                    return;
                }
                this.privateData(type, null);
            }

            private long complexity(String string) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                for (char c : string.toCharArray()) {
                    if (c >= 'a' && c <= 'z') {
                        bl = true;
                        continue;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        bl2 = true;
                        continue;
                    }
                    if (c >= '0' && c <= '9') {
                        bl3 = true;
                        continue;
                    }
                    if (bl4) continue;
                    bl4 = true;
                }
                int n = 0 + (bl ? 26 : 0) + (bl2 ? 26 : 0) + (bl3 ? 10 : 0) + (bl4 ? 8 : 0);
                BigDecimal bigDecimal = BigDecimal.valueOf(n).pow(string.length());
                try {
                    return bigDecimal.longValueExact();
                }
                catch (Exception exception) {
                    return Long.MAX_VALUE;
                }
            }
        }
    }

    public static abstract class Remote
    extends Type {
        public abstract String loginPageRedirectUrl();

        @Override
        public Data export() {
            return super.export().put("login_redirect", this.loginPageRedirectUrl());
        }
    }

    public static abstract class Type
    extends Entity {
        private String key = null;

        protected final Data privateData(User.Type type) {
            try {
                if (type == null) {
                    return Data.map();
                }
                Data data = Manager.of(Vault.class).get(Manager.of(Security.class).hash(this.id() + "." + type.id()), this.key);
                if (data.isEmpty()) {
                    return data;
                }
                return Json.decode(data.asString());
            }
            catch (Exception exception) {
                return Data.map();
            }
        }

        protected final void privateData(User.Type type, Data data) {
            if (type == null) {
                throw new IllegalArgumentException("Invalid user");
            }
            if (data != null && !data.isMap()) {
                throw new IllegalArgumentException("Invalid data");
            }
            try {
                if (data == null) {
                    Manager.of(Vault.class).remove(Manager.of(Security.class).hash(this.id() + "." + type.id()), this.key);
                } else {
                    Manager.of(Vault.class).set(Manager.of(Security.class).hash(this.id() + "." + type.id()), data, this.key);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Operation failed");
            }
        }

        public abstract boolean supports(String var1);

        public abstract User.Type authenticate(Data var1);

        public abstract User.Type join(Data var1, User.Type var2);

        public abstract void leave(User.Type var1);

        public boolean check(Rule.Type type, User.Type type2, Data data) {
            return true;
        }

        public boolean active() {
            return this.valueOf("active").asBool();
        }

        @Override
        public final String category() {
            return StringUtils.toLowerCase(Provider.class);
        }

        @Override
        public Data snapshot() {
            return super.snapshot().put("key", this.key);
        }
    }
}

