/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity.security;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.Registry;
import aeonics.entity.security.Provider;
import aeonics.entity.security.User;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.template.Template;
import aeonics.util.StringUtils;
import aeonics.util.Tuples;
import java.util.function.BiPredicate;
import java.util.function.Supplier;

public abstract class Rule
extends Item<Type> {
    @Override
    protected Class<? extends Rule> category() {
        return Rule.class;
    }

    public static class Role
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)super.template().summary("User role")).description("Checks if the user has the specified role.")).add((Parameter)((Parameter)((Parameter)new Parameter("role").summary("Role name or id")).description("The role name or id to match. This property can include a wildcard pattern in case of the role name.")).format("text"));
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                try {
                    String string = this.valueOf("role").asString();
                    for (Tuples.Tuple tuple : type.relations("roles")) {
                        if (!((Entity)tuple.a).id().equals(string) && !StringUtils.simplePathMatches(string, ((Entity)tuple.a).name())) continue;
                        return true;
                    }
                    for (Tuples.Tuple tuple : type.relations("groups")) {
                        for (Tuples.Tuple tuple2 : ((Entity)tuple.a).relations("roles")) {
                            if (!((Entity)tuple2.a).id().equals(string) && !StringUtils.simplePathMatches(string, ((Entity)tuple2.a).name())) continue;
                            return true;
                        }
                    }
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
    }

    public static class Group
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)super.template().summary("User group")).description("Checks if the user is a member of the specified group.")).add((Parameter)((Parameter)((Parameter)new Parameter("group").summary("Group name or id")).description("The group name or id to match. This property can include a wildcard pattern in case of the group name.")).format("text"));
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                try {
                    String string = this.valueOf("group").asString();
                    for (Tuples.Tuple tuple : type.relations("groups")) {
                        if (!((Entity)tuple.a).id().equals(string) && !StringUtils.simplePathMatches(string, ((Entity)tuple.a).name())) continue;
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
    }

    public static class AskProviders
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)super.template().summary("Ask providers")).description("Delegates the decision to all identity providers that support the user. The rule will pass only if all applicable providers allow it.");
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                try {
                    for (Provider.Type type2 : Registry.of(Provider.class)) {
                        if (!type2.supports(type.id()) || type2.check(this, type, data)) continue;
                        return false;
                    }
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
    }

    public static class MatchContext
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)((Template)((Template)super.template().summary("Match context")).description("A security rule that checks the current context data to verify if a property is equal to the specified value.")).add((Parameter)((Parameter)((Parameter)new Parameter("property").summary("Property name")).description("The name of the context property to match.")).format("text"))).add((Parameter)((Parameter)((Parameter)new Parameter("value").summary("Expected value")).description("The expected value of the context property to match")).format("text"))).add((Parameter)((Parameter)((Parameter)new Parameter("wildcard").summary("Wildcard pattern")).description("Whether or not the value should be applied using the wildcard path logic.")).rule(Parameter.Rule.BOOLEAN).format("boolean"));
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                if (data == null || !data.isMap()) {
                    return false;
                }
                String string = this.valueOf("property").asString();
                Data data2 = this.valueOf("value");
                if (this.valueOf("wildcard").asBool()) {
                    return StringUtils.simplePathMatches(data2.asString(), data.getNested(string).asString());
                }
                return data.getNested(string).equals(data2);
            }
        }
    }

    public static class MatchAttribute
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)((Template)super.template().summary("Match user attribute")).description("A security rule that checks if a user attribute is equal to the specified value. The attribute may be inherited by one of the user groups or roles.")).add((Parameter)((Parameter)((Parameter)new Parameter("attribute").summary("Attribute name")).description("The name of the user attribute to match.")).format("text"))).add((Parameter)((Parameter)((Parameter)new Parameter("value").summary("Expected value")).description("The expected value of the user attribute to match")).format("text"));
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                if (type == null) {
                    return false;
                }
                String string = this.valueOf("attribute").asString();
                Data data2 = this.valueOf("value");
                Data data3 = type.valueOf("attributes");
                if (data3.isMap() && data3.equals(string, (Object)data2)) {
                    return true;
                }
                for (Tuples.Tuple tuple : type.relations("roles")) {
                    if (tuple.a == null || !(data3 = ((Entity)tuple.a).valueOf("attributes")).isMap() || !data3.equals(string, (Object)data2)) continue;
                    return true;
                }
                for (Tuples.Tuple tuple : type.relations("groups")) {
                    if (tuple.a == null) continue;
                    Group.Type type2 = (Group.Type)((Entity)tuple.a).cast();
                    data3 = type2.valueOf("attributes");
                    if (data3.isMap() && data3.equals(string, (Object)data2)) {
                        return true;
                    }
                    for (Tuples.Tuple tuple2 : type2.relations("roles")) {
                        if (tuple2.a == null || !(data3 = ((Entity)tuple2.a).valueOf("attributes")).isMap() || !data3.equals(string, (Object)data2)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
    }

    public static class MatchNone
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)super.template().summary("Match none")).description("A security rule that does not match anything no matter what.");
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                return false;
            }
        }
    }

    public static class MatchAll
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)super.template().summary("Match all")).description("A security rule that matches everything without any conditions.");
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                return true;
            }
        }
    }

    public static class Xor
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)super.template().summary("XOR")).description("Match multiple rules with the XOR conditional logic. That is, the rule matches if exactly-and-only one of the related rules also match.")).add((Relationship)((Relationship)((Relationship)new Relationship("rules").category(Rule.class)).summary("Rules")).description("Other rules to match"));
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                boolean bl = false;
                for (Tuples.Tuple tuple : this.relations("rules")) {
                    if (!((aeonics.entity.security.Rule$Type)tuple.a).test(type, data)) continue;
                    if (bl) {
                        return false;
                    }
                    bl = true;
                }
                return bl;
            }
        }
    }

    public static class Or
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)super.template().summary("OR")).description("Match multiple rules with the OR conditional logic. That is, the rule matches if at least one of the related rules also match.")).add((Relationship)((Relationship)((Relationship)new Relationship("rules").category(Rule.class)).summary("Rules")).description("Other rules to match"));
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                for (Tuples.Tuple tuple : this.relations("rules")) {
                    if (!((aeonics.entity.security.Rule$Type)tuple.a).test(type, data)) continue;
                    return true;
                }
                return false;
            }
        }
    }

    public static class Not
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)super.template().summary("NOT")).description("Inverts the related rule.")).add((Relationship)((Relationship)((Relationship)((Relationship)new Relationship("rule").category(Rule.class)).summary("Rule")).description("Other rules to invert")).max(1));
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                aeonics.entity.security.Rule$Type type2 = (aeonics.entity.security.Rule$Type)this.firstRelation("rule");
                if (type2 != null) {
                    return !type2.test(type, data);
                }
                return true;
            }
        }
    }

    public static class And
    extends Rule {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)super.template().summary("AND")).description("Match multiple rules with the AND conditional logic. That is, the rule matches only if all related rules also match.")).add((Relationship)((Relationship)((Relationship)new Relationship("rules").category(Rule.class)).summary("Rules")).description("Other rules to match"));
        }

        public static class Type
        extends aeonics.entity.security.Rule$Type {
            @Override
            public boolean test(User.Type type, Data data) {
                for (Tuples.Tuple tuple : this.relations("rules")) {
                    if (((aeonics.entity.security.Rule$Type)tuple.a).test(type, data)) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public static abstract class Type
    extends Entity
    implements BiPredicate<User.Type, Data> {
        @Override
        public final String category() {
            return StringUtils.toLowerCase(Rule.class);
        }
    }
}

