/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.manager.Manager;
import aeonics.template.Factory;
import aeonics.template.Template;
import aeonics.util.Callback;
import aeonics.util.Functions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public abstract class Lifecycle
extends Manager.Type {
    private static Map<Phase, Callback<Phase, Lifecycle>> before = new ConcurrentHashMap<Phase, Callback<Phase, Lifecycle>>();
    private static Map<Phase, Callback<Phase, Lifecycle>> on = new ConcurrentHashMap<Phase, Callback<Phase, Lifecycle>>();
    private static Map<Phase, Callback<Phase, Lifecycle>> after = new ConcurrentHashMap<Phase, Callback<Phase, Lifecycle>>();
    public static final Lifecycle NOOP = Manager.set(Lifecycle.class, (Lifecycle)Factory.add(new NoopLifecycle()).create().name("Noop Lifecycle"));

    @Override
    public final Class<? extends Manager.Type> manager() {
        return Lifecycle.class;
    }

    public static Lifecycle get() {
        return Manager.of(Lifecycle.class);
    }

    public abstract Phase phase();

    public abstract void boot();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void before(Phase phase2, Callback.Once<Phase, Lifecycle> once) {
        Phase phase3 = phase2;
        synchronized (phase3) {
            before.computeIfAbsent(phase2, phase -> new Callback(() -> Manager.of(Lifecycle.class))).then(once);
        }
    }

    public static void before(Phase phase, Functions.Runnable runnable) {
        Lifecycle.before(phase, Callback.once(runnable));
    }

    protected static Callback<Phase, Lifecycle> before(Phase phase) {
        return before.getOrDefault((Object)phase, new Callback(() -> Manager.of(Lifecycle.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void on(Phase phase2, Callback.Once<Phase, Lifecycle> once) {
        Phase phase3 = phase2;
        synchronized (phase3) {
            on.computeIfAbsent(phase2, phase -> new Callback(() -> Manager.of(Lifecycle.class))).then(once);
        }
    }

    public static void on(Phase phase, Functions.Runnable runnable) {
        Lifecycle.on(phase, Callback.once(runnable));
    }

    protected static Callback<Phase, Lifecycle> on(Phase phase) {
        return on.getOrDefault((Object)phase, new Callback(() -> Manager.of(Lifecycle.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void after(Phase phase2, Callback.Once<Phase, Lifecycle> once) {
        Phase phase3 = phase2;
        synchronized (phase3) {
            after.computeIfAbsent(phase2, phase -> new Callback(() -> Manager.of(Lifecycle.class))).then(once);
        }
    }

    public static void after(Phase phase, Functions.Runnable runnable) {
        Lifecycle.after(phase, Callback.once(runnable));
    }

    protected static Callback<Phase, Lifecycle> after(Phase phase) {
        return after.getOrDefault((Object)phase, new Callback(() -> Manager.of(Lifecycle.class)));
    }

    private static final class NoopLifecycle
    extends Manager<Lifecycle> {
        private NoopLifecycle() {
        }

        @Override
        public Template<? extends Lifecycle> template() {
            return ((Template)((Template)new Template(this.target(), this.type(), this.category()).creator(this.creator())).summary("Noop Lifecycle")).description("Does nothing.");
        }

        @Override
        protected Class<? extends Implementation> defaultTarget() {
            return Implementation.class;
        }

        @Override
        protected Supplier<? extends Implementation> defaultCreator() {
            return () -> new Implementation();
        }

        private static class Implementation
        extends Lifecycle {
            private Implementation() {
            }

            @Override
            public void boot() {
                throw new IllegalStateException("This Lifecycle implementation is a shim. You should use a real implementation instead.");
            }

            @Override
            public Phase phase() {
                return Phase.BOOT;
            }
        }
    }

    public static enum Phase {
        BOOT,
        LOAD,
        CONFIG,
        RUN,
        SHUTDOWN;

    }
}

