/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.data.Data;
import aeonics.manager.Executor;
import aeonics.manager.Manager;
import aeonics.util.Callback;
import aeonics.util.Functions;
import java.util.Collection;

public abstract class Snapshot
extends Manager.Type {
    protected static Callback<Data, Snapshot> createCallback = new Callback(() -> Manager.of(Snapshot.class));
    protected static Callback<Data, Snapshot> restoreCallback = new Callback(() -> Manager.of(Snapshot.class));

    @Override
    public final Class<? extends Manager.Type> manager() {
        return Snapshot.class;
    }

    public static Snapshot get() {
        return Manager.of(Snapshot.class);
    }

    public static void onSnapshot(Functions.Consumer<Data> consumer) {
        createCallback.then(new ModuleAwareBiConsumer(consumer));
    }

    public static void onRestore(Functions.Consumer<Data> consumer) {
        restoreCallback.then(new ModuleAwareBiConsumer(consumer));
    }

    public abstract Executor.Task<String> create(String var1);

    public abstract Executor.Task<Void> restore(String var1);

    public abstract void upload(byte[] var1);

    public abstract byte[] download(String var1);

    public abstract Collection<String> list();

    public abstract void remove(String var1);

    public abstract boolean exists(String var1);

    public abstract String latest();

    protected static class ModuleAwareBiConsumer
    implements Functions.BiConsumer<Data, Snapshot> {
        private Functions.Consumer<Data> handler = null;

        private ModuleAwareBiConsumer(Functions.Consumer<Data> consumer) {
            this.handler = consumer;
        }

        public Class<?> origin() {
            return this.handler == null ? null : this.handler.getClass();
        }

        @Override
        public void accept(Data data, Snapshot snapshot) throws Exception {
            if (this.handler != null) {
                this.handler.accept(data);
            }
        }
    }
}

