/*
 * Decompiled with CFR 0.152.
 */
package aeonics.template;

import aeonics.entity.Entity;
import aeonics.template.Template;
import java.util.function.Supplier;

public abstract class Item<T extends Entity> {
    private Class<? extends T> target = null;
    private Class<? extends Item<? super T>> type = null;
    private Supplier<? extends T> creator = null;

    public Template<? extends T> template() {
        Object u = new Template<T>(this.target(), this.type(), this.category()).creator(this.creator());
        return u;
    }

    public Class<? extends T> target() {
        return this.target == null ? this.defaultTarget() : this.target;
    }

    public Item<T> target(Class<? extends T> clazz) {
        this.target = clazz;
        return this;
    }

    protected abstract Class<? extends T> defaultTarget();

    public Class<? extends Item<? super T>> type() {
        return this.type == null ? this.defaultType() : this.type;
    }

    public Item<T> type(Class<? extends Item<? super T>> clazz) {
        this.type = clazz;
        return this;
    }

    protected Class<? extends Item<? super T>> defaultType() {
        return this.getClass();
    }

    public Supplier<? extends T> creator() {
        return this.creator == null ? this.defaultCreator() : this.creator;
    }

    public Item<T> creator(Supplier<? extends T> supplier) {
        this.creator = supplier;
        return this;
    }

    protected abstract Supplier<? extends T> defaultCreator();

    protected abstract Class<? extends Item<? super T>> category();

    public static <X extends Entity> Item<X> from(final Class<? extends Item<? super X>> clazz, final Class<X> clazz2, final Supplier<X> supplier) {
        return new Item<X>(){

            @Override
            protected Class<? extends X> defaultTarget() {
                return clazz2;
            }

            @Override
            protected Supplier<? extends X> defaultCreator() {
                return supplier;
            }

            @Override
            protected Class<? extends Item<? super X>> category() {
                return clazz;
            }
        };
    }
}

