/*
 * Decompiled with CFR 0.152.
 */
package aeonics.template;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.util.Documented;
import aeonics.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class Relationship
implements Documented {
    private String name;
    private String summary = "";
    private String description = "";
    private String category = null;
    private int min = 0;
    private int max = -1;
    private boolean ordered = false;
    private Map<String, Parameter> parameters = new HashMap<String, Parameter>();

    public Relationship(String string) {
        if (string == null || string.isBlank()) {
            throw new IllegalArgumentException("Relationship name is mandatory");
        }
        this.name = string;
        this.add((Parameter)((Parameter)((Parameter)new Parameter("id").summary("The related entity id.")).description("The related entity id. The related entity will be fetched from the Registry when needed.")).optional(false).format("text"));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String summary() {
        return this.summary;
    }

    public <R extends Relationship> R summary(String string) {
        this.summary = string;
        return (R)this;
    }

    @Override
    public String description() {
        return this.description;
    }

    public <R extends Relationship> R description(String string) {
        this.description = string;
        return (R)this;
    }

    public String category() {
        return this.category;
    }

    public <R extends Relationship> R category(Class<? extends Item<? extends Entity>> clazz) {
        this.category = StringUtils.toLowerCase(clazz);
        return (R)this;
    }

    public <R extends Relationship> R category(String string) {
        this.category = string;
        return (R)this;
    }

    public int min() {
        return this.min;
    }

    public <R extends Relationship> R min(int n) {
        this.min = n;
        return (R)this;
    }

    public int max() {
        return this.max;
    }

    public <R extends Relationship> R max(int n) {
        this.max = n;
        return (R)this;
    }

    public boolean ordered() {
        return this.ordered;
    }

    public <R extends Relationship> R ordered(boolean bl) {
        this.ordered = bl;
        return (R)this;
    }

    public Map<String, Parameter> parameters() {
        return this.parameters;
    }

    public <R extends Relationship> R add(Parameter parameter) {
        this.parameters.put(parameter.name(), parameter);
        return (R)this;
    }

    @Override
    public Data export() {
        Data data = Data.map();
        for (Parameter parameter : this.parameters().values()) {
            data.put(parameter.name(), parameter.export());
        }
        return Documented.super.export().put("min", this.min()).put("max", this.max()).put("ordered", this.ordered()).put("category", StringUtils.toLowerCase(this.category())).put("parameters", data);
    }
}

