/*
 * Decompiled with CFR 0.152.
 */
package aeonics.template;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.Registry;
import aeonics.manager.Config;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Factory;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.util.Callback;
import aeonics.util.Documented;
import aeonics.util.Functions;
import aeonics.util.Json;
import aeonics.util.Snapshotable;
import aeonics.util.StringUtils;
import aeonics.util.Tuples;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class Template<T extends Entity>
implements Documented {
    private Supplier<? extends T> creator = null;
    private Map<String, Parameter> parameters = new HashMap<String, Parameter>();
    private List<String> configs = new ArrayList<String>();
    private Map<String, Relationship> relationships = new HashMap<String, Relationship>();
    private Class<? extends T> target;
    private String category;
    private Class<? extends Item<? super T>> type = null;
    private String summary = "";
    private String description = "";
    private boolean enforceParameterValidation = true;
    private ThreadLocal<T> current = new ThreadLocal();
    private Callback<Data, T> onCreate = new Callback(() -> (Entity)this.current.get());
    private Callback<Data, T> onUpdate = new Callback(() -> (Entity)this.current.get());

    public <X extends Template<?>> X cast() {
        return (X)this;
    }

    private Supplier<? extends T> creator() {
        return this.creator;
    }

    public <U extends Template<T>> U creator(Supplier<? extends T> supplier) {
        this.creator = supplier;
        return (U)this;
    }

    public Collection<Parameter> parameters() {
        return Collections.unmodifiableCollection(this.parameters.values());
    }

    public <U extends Template<T>> U add(Parameter parameter) {
        this.parameters.put(parameter.name(), parameter);
        return (U)this;
    }

    public <U extends Template<T>> U removeParameter(String string) {
        this.parameters.remove(string);
        return (U)this;
    }

    public <U extends Template<T>> U clearParameters() {
        this.parameters.clear();
        return (U)this;
    }

    public <U extends Template<T>> U config(Parameter parameter) {
        Manager.of(Config.class).declare(this.type(), parameter);
        return this.config(this.type(), parameter.name());
    }

    public <U extends Template<T>> U config(Class<?> clazz, Parameter parameter) {
        Manager.of(Config.class).declare(clazz, parameter);
        return this.config(clazz, parameter.name());
    }

    public <U extends Template<T>> U config(Class<?> clazz, String string) {
        this.configs.add(Config.implodeName(clazz, string));
        return (U)this;
    }

    public <U extends Template<T>> U config(String string, String string2) {
        this.configs.add(Config.implodeName(string, string2));
        return (U)this;
    }

    public <U extends Template<T>> U config(String string) {
        this.configs.add(Config.implodeName(Config.explodeName(string)));
        return (U)this;
    }

    public <U extends Template<T>> U add(Relationship relationship) {
        this.relationships.put(relationship.name(), relationship);
        return (U)this;
    }

    public <U extends Template<T>> U removeRelationship(String string) {
        this.relationships.remove(string);
        return (U)this;
    }

    public Class<? extends T> target() {
        return this.target;
    }

    public <U extends Template<T>> U target(Class<? extends T> clazz) {
        this.target = clazz;
        return (U)this;
    }

    public String category() {
        return this.category;
    }

    public <U extends Template<T>> U category(String string) {
        this.category = StringUtils.toLowerCase(string);
        return (U)this;
    }

    public <U extends Template<T>> U category(Class<? extends Item<? super T>> clazz) {
        this.category = StringUtils.toLowerCase(clazz);
        return (U)this;
    }

    public Class<? extends Item<? super T>> type() {
        return this.type;
    }

    public <U extends Template<T>> U type(Class<? extends Item<? super T>> clazz) {
        this.type = clazz;
        return (U)this;
    }

    public Template(Class<? extends T> clazz, Class<? extends Item<? super T>> clazz2, Class<? extends Item<? super T>> clazz3) {
        this.target = Objects.requireNonNull(clazz);
        this.type = clazz2;
        this.category = StringUtils.toLowerCase(clazz3);
        Factory.add(this);
    }

    @Override
    public String name() {
        return StringUtils.toLowerCase(this.target());
    }

    @Override
    public String summary() {
        return this.summary;
    }

    public <U extends Template<T>> U summary(String string) {
        this.summary = string;
        return (U)this;
    }

    @Override
    public String description() {
        return this.description;
    }

    public <U extends Template<T>> U description(String string) {
        this.description = string;
        return (U)this;
    }

    public boolean enforceParameterValidation() {
        return this.enforceParameterValidation;
    }

    public <U extends Template<T>> U enforceParameterValidation(boolean bl) {
        this.enforceParameterValidation = bl;
        return (U)this;
    }

    public <U extends Template<T>> U onCreate(Functions.BiConsumer<Data, T> biConsumer) {
        this.onCreate.then(biConsumer);
        return (U)this;
    }

    public T create() {
        return this.create(null);
    }

    /*
     * WARNING - void declaration
     */
    public T create(Data data) {
        if (data == null) {
            data = Data.map();
        }
        if (data.containsKey("mode") && Snapshotable.SnapshotMode.FULL != Snapshotable.SnapshotMode.valueOf(data.asString("mode"))) {
            throw new RuntimeException("Incompatible snapshot mode");
        }
        if (data.containsKey("category") && !this.category().equals(data.asString("category"))) {
            throw new RuntimeException("Entity category mismatch");
        }
        if (data.containsKey("type") && !StringUtils.toLowerCase(this.type()).equals(data.asString("type"))) {
            throw new RuntimeException("Entity type mismatch");
        }
        Supplier<T> supplier = this.creator();
        if (supplier == null) {
            throw new RuntimeException("No creator defined for this template");
        }
        Entity entity = (Entity)supplier.get();
        if (!this.target().isInstance(entity)) {
            throw new RuntimeException("Entity instance does not match the target type");
        }
        boolean bl = entity.internal();
        if (data.containsKey("internal")) {
            bl = data.asBool("internal");
        }
        entity.initialize(this.category(), StringUtils.toLowerCase(this.type()), data.asString("id"), bl);
        if (!entity.category().equals(this.category())) {
            throw new RuntimeException("Entity category mismatch: " + entity.category() + " <> " + this.category());
        }
        if (!entity.type().equals(StringUtils.toLowerCase(this.type()))) {
            throw new RuntimeException("Entity type mismatch: " + entity.type() + " <> " + this.type());
        }
        if (!data.containsKey("name")) {
            entity.name(StringUtils.toLowerCase(this.target()) + "-" + entity.id());
        } else {
            entity.name(data.asString("name"));
        }
        Data data2 = data.containsKey("parameters") && !data.isNull("parameters") ? data.get("parameters") : Data.map();
        if (!data2.isMap()) {
            throw new RuntimeException("Invalid entity parameters");
        }
        for (Parameter object : this.parameters.values()) {
            void var8_12;
            Data data3 = data2.get(object.name());
            if (this.enforceParameterValidation() && !object.validate(data3)) {
                throw new RuntimeException("Invalid value for parameter " + object.name());
            }
            if (object.format().equals("json") && data3.isString()) {
                Data data4 = Json.decode(data3.asString());
            }
            entity.parameters().put(object.name(), Tuples.Tuple.of(var8_12, object));
        }
        Data data3 = data.containsKey("relationships") && !data.isNull("relationships") ? data.get("relationships") : Data.map();
        if (!data3.isMap()) {
            throw new RuntimeException("Invalid entity relationships");
        }
        for (Relationship relationship : this.relationships.values()) {
            void var9_18;
            Data data5;
            entity.defineRelation(relationship);
            Data data6 = data5 = data3.containsKey(relationship.name()) ? data3.get(relationship.name()) : Data.list();
            if (!data5.isList()) {
                Data data7 = Data.list().add((Object)data5);
            }
            if (relationship.min() > 0 && var9_18.size() < relationship.min() || relationship.max() > 0 && var9_18.size() > relationship.max()) {
                throw new RuntimeException("Invalid count for relationship " + relationship.name());
            }
            for (Data data8 : var9_18) {
                for (Parameter parameter : relationship.parameters().values()) {
                    Data data9 = data8.get(parameter.name());
                    if (this.enforceParameterValidation() && !parameter.validate(data9)) {
                        throw new RuntimeException("Invalid value for parameter " + parameter.name() + " of relationship " + relationship.name());
                    }
                    if (!parameter.format().equals("json") || !data9.isString()) continue;
                    data8.put(parameter.name(), Json.decode(data9.asString()));
                }
                entity.addUncheckedRelation(relationship.name(), data8.asString("id"), data8);
            }
        }
        if (Manager.of(Config.class) != null) {
            Config config = Manager.of(Config.class);
            for (String string : this.configs) {
                config.watch(string, entity::config);
            }
        }
        Registry.add(entity);
        this.current.set(entity);
        try {
            this.onCreate.trigger(data);
        }
        catch (Exception exception) {
            Manager.of(Logger.class).warning(Template.class, (Throwable)exception);
        }
        this.current.set(null);
        entity.onCreate().trigger(data);
        return (T)entity;
    }

    public <U extends Template<T>> U onUpdate(Functions.BiConsumer<Data, T> biConsumer) {
        this.onUpdate.then(biConsumer);
        return (U)this;
    }

    /*
     * WARNING - void declaration
     */
    public T update(Data data, T t) {
        Object object;
        Data data2;
        if (data == null || !data.isMap() || data.isEmpty() || t == null) {
            return t;
        }
        if (data.containsKey("name")) {
            ((Entity)t).name(data.asString("name"));
        }
        if (!(data2 = data.containsKey("parameters") && !data.isNull("parameters") ? data.get("parameters") : Data.map()).isMap()) {
            throw new RuntimeException("Invalid entity parameters");
        }
        for (Parameter object2 : this.parameters.values()) {
            void var6_8;
            if (!data2.containsKey(object2.name())) continue;
            Data data3 = data2.get(object2.name());
            if (this.enforceParameterValidation() && !object2.validate(data3)) {
                throw new RuntimeException("Invalid value for parameter " + object2.name());
            }
            if (object2.format().equals("json") && data3.isString()) {
                Data data4 = Json.decode(data3.asString());
            }
            if ((object = ((Entity)t).parameters().get(object2.name())) == null) {
                ((Entity)t).parameters().put(object2.name(), Tuples.Tuple.of(var6_8, object2));
                continue;
            }
            ((Tuples.Tuple)object).a = var6_8;
        }
        Data data3 = data.containsKey("relationships") && !data.isNull("relationships") ? data.get("relationships") : Data.map();
        if (!data3.isMap()) {
            throw new RuntimeException("Invalid entity relationships");
        }
        for (Relationship relationship : this.relationships.values()) {
            if (!data3.containsKey(relationship.name())) continue;
            ((Entity)t).clearRelation(relationship.name());
            object = data3.get(relationship.name());
            if (!object.isList()) {
                object = Data.list().add(object);
            }
            if (relationship.min() > 0 && object.size() < relationship.min() || relationship.max() > 0 && object.size() > relationship.max()) {
                throw new RuntimeException("Invalid count for relationship " + relationship.name());
            }
            Iterator<Data> iterator = object.iterator();
            while (iterator.hasNext()) {
                Data data5 = iterator.next();
                for (Parameter parameter : relationship.parameters().values()) {
                    Data data6 = data5.get(parameter.name());
                    if (this.enforceParameterValidation() && !parameter.validate(data6)) {
                        throw new RuntimeException("Invalid value for parameter " + parameter.name() + " of relationship " + relationship.name());
                    }
                    if (!parameter.format().equals("json") || !data6.isString()) continue;
                    data5.put(parameter.name(), Json.decode(data6.asString()));
                }
                ((Entity)t).addUncheckedRelation(relationship.name(), data5.asString("id"), data5);
            }
        }
        this.current.set(t);
        try {
            this.onUpdate.trigger(data);
        }
        catch (Exception exception) {
            Manager.of(Logger.class).warning(Template.class, (Throwable)exception);
        }
        this.current.set(null);
        ((Entity)t).onUpdate().trigger(data);
        return t;
    }

    @Override
    public Data export() {
        Data data = Data.map();
        for (Parameter object2 : this.parameters.values()) {
            data.put(object2.name(), object2.export());
        }
        Data data2 = Data.map();
        for (Relationship relationship : this.relationships.values()) {
            data2.put(relationship.name(), relationship.export());
        }
        Data data3 = Data.map();
        for (String string : this.configs) {
            Tuples.Tuple<String, String> tuple = Config.explodeName(string);
            Parameter parameter = Manager.of(Config.class).definition((String)tuple.a, (String)tuple.b);
            data3.put(string, parameter == null ? null : parameter.export());
        }
        return Documented.super.export().put("type_plugin", this.type().getModule().getName()).put("target_plugin", this.target().getModule().getName()).put("parameters", data).put("relations", data2).put("configs", data3).put("category", this.category()).put("type", StringUtils.toLowerCase(this.type())).put("target", StringUtils.toLowerCase(this.target())).put("enforceParameterValidation", this.enforceParameterValidation());
    }
}

