/*
 * Decompiled with CFR 0.152.
 */
package aeonics.util;

import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.util.Functions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class Callback<V, T>
implements Iterable<Functions.BiConsumer<V, T>> {
    private Functions.Supplier<T> target;
    private Queue<Functions.BiConsumer<V, T>> handlers = new ConcurrentLinkedQueue<Functions.BiConsumer<V, T>>();

    public Callback(T t) {
        this(() -> t);
    }

    public Callback(Functions.Supplier<T> supplier) {
        this.target = Objects.requireNonNullElse(supplier, () -> null);
    }

    public static <U, S> Once<U, S> once(Functions.BiConsumer<U, S> biConsumer) {
        Objects.requireNonNull(biConsumer);
        return new Once<U, S>(biConsumer);
    }

    public static <U, S> Once<U, S> once(Functions.Runnable runnable) {
        Objects.requireNonNull(runnable);
        return new Once<Object, Object>((object, object2) -> runnable.run());
    }

    public void then(Functions.BiConsumer<V, T> biConsumer) {
        this.handlers.offer(biConsumer);
    }

    public void remove(Functions.BiConsumer<V, T> biConsumer) {
        this.handlers.remove(biConsumer);
    }

    public void clear() {
        this.handlers.clear();
    }

    public void trigger() {
        this.trigger(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(V v) {
        if (this.handlers.size() == 0) {
            return;
        }
        ArrayList<Functions.BiConsumer<V, T>> arrayList = new ArrayList<Functions.BiConsumer<V, T>>(this.handlers);
        try {
            T t = this.target.get();
            for (Functions.BiConsumer biConsumer : arrayList) {
                if (biConsumer == null) continue;
                try {
                    biConsumer.accept(v, t);
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).warning(Callback.class, (Throwable)exception);
                }
                finally {
                    if (!(biConsumer instanceof Once)) continue;
                    this.remove(biConsumer);
                }
            }
        }
        catch (Exception exception) {
            Manager.of(Logger.class).warning(Callback.class, (Throwable)exception);
        }
    }

    @Override
    public Iterator<Functions.BiConsumer<V, T>> iterator() {
        return Collections.unmodifiableCollection(this.handlers).iterator();
    }

    public static class Once<U, S>
    implements Functions.BiConsumer<U, S> {
        private AtomicBoolean accepted = new AtomicBoolean(false);
        private Functions.BiConsumer<U, S> handler;

        private Once(Functions.BiConsumer<U, S> biConsumer) {
            this.handler = biConsumer;
        }

        @Override
        public void accept(U u, S s) throws Exception {
            if (!this.accepted.compareAndSet(false, true)) {
                return;
            }
            this.handler.accept(u, s);
        }
    }
}

