/*
 * Decompiled with CFR 0.152.
 */
package aeonics.util;

import java.util.Objects;

public class Functions {
    private Functions() {
    }

    @FunctionalInterface
    public static interface QuadriFunction<A, B, C, D, R>
    extends TriFunction<A, B, C, R> {
        @Override
        default public R apply(A a, B b, C c) throws Exception {
            return this.apply(a, b, c, null);
        }

        public R apply(A var1, B var2, C var3, D var4) throws Exception;
    }

    @FunctionalInterface
    public static interface QuadriConsumer<A, B, C, D>
    extends TriConsumer<A, B, C> {
        @Override
        default public void accept(A a, B b, C c) throws Exception {
            this.accept(a, b, c, null);
        }

        public void accept(A var1, B var2, C var3, D var4) throws Exception;
    }

    @FunctionalInterface
    public static interface QuadriPredicate<A, B, C, D>
    extends TriPredicate<A, B, C> {
        @Override
        default public boolean test(A a, B b, C c) throws Exception {
            return this.test(a, b, c, null);
        }

        public boolean test(A var1, B var2, C var3, D var4) throws Exception;
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R>
    extends BiFunction<A, B, R> {
        @Override
        default public R apply(A a, B b) throws Exception {
            return this.apply(a, b, null);
        }

        public R apply(A var1, B var2, C var3) throws Exception;
    }

    @FunctionalInterface
    public static interface TriConsumer<A, B, C>
    extends BiConsumer<A, B> {
        @Override
        default public void accept(A a, B b) throws Exception {
            this.accept(a, b, null);
        }

        public void accept(A var1, B var2, C var3) throws Exception;
    }

    @FunctionalInterface
    public static interface TriPredicate<A, B, C>
    extends BiPredicate<A, B> {
        @Override
        default public boolean test(A a, B b) throws Exception {
            return this.test(a, b, null);
        }

        public boolean test(A var1, B var2, C var3) throws Exception;

        default public TriPredicate<A, B, C> or(TriPredicate<? super A, ? super B, ? super C> triPredicate) {
            Objects.requireNonNull(triPredicate);
            return (object, object2, object3) -> this.test(object, object2, object3) || triPredicate.test(object, object2, object3);
        }

        default public TriPredicate<A, B, C> and(TriPredicate<? super A, ? super B, ? super C> triPredicate) {
            Objects.requireNonNull(triPredicate);
            return (object, object2, object3) -> this.test(object, object2, object3) && triPredicate.test(object, object2, object3);
        }

        @Override
        default public TriPredicate<A, B, C> negate() {
            return (object, object2, object3) -> !this.test(object, object2, object3);
        }

        public static <A, B, C> TriPredicate<A, B, C> not(TriPredicate<? super A, ? super B, ? super C> triPredicate) {
            Objects.requireNonNull(triPredicate);
            return triPredicate.negate();
        }
    }

    @FunctionalInterface
    public static interface BiFunction<A, B, R>
    extends Function<A, R> {
        @Override
        default public R apply(A a) throws Exception {
            return this.apply(a, null);
        }

        public R apply(A var1, B var2) throws Exception;
    }

    @FunctionalInterface
    public static interface BiConsumer<A, B>
    extends Consumer<A> {
        @Override
        default public void accept(A a) throws Exception {
            this.accept(a, null);
        }

        public void accept(A var1, B var2) throws Exception;
    }

    @FunctionalInterface
    public static interface BiPredicate<A, B>
    extends Predicate<A> {
        @Override
        default public boolean test(A a) throws Exception {
            return this.test(a, null);
        }

        public boolean test(A var1, B var2) throws Exception;

        default public BiPredicate<A, B> or(BiPredicate<? super A, ? super B> biPredicate) {
            Objects.requireNonNull(biPredicate);
            return (object, object2) -> this.test(object, object2) || biPredicate.test(object, object2);
        }

        default public BiPredicate<A, B> and(BiPredicate<? super A, ? super B> biPredicate) {
            Objects.requireNonNull(biPredicate);
            return (object, object2) -> this.test(object, object2) && biPredicate.test(object, object2);
        }

        default public BiPredicate<A, B> negate() {
            return (object, object2) -> !this.test(object, object2);
        }

        public static <A, B> BiPredicate<A, B> not(BiPredicate<? super A, ? super B> biPredicate) {
            Objects.requireNonNull(biPredicate);
            return biPredicate.negate();
        }
    }

    @FunctionalInterface
    public static interface Function<A, R> {
        public R apply(A var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Consumer<A> {
        public void accept(A var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Predicate<A> {
        public boolean test(A var1) throws Exception;

        default public Predicate<A> or(Predicate<? super A> predicate) {
            Objects.requireNonNull(predicate);
            return object -> this.test(object) || predicate.test(object);
        }

        default public Predicate<A> and(Predicate<? super A> predicate) {
            Objects.requireNonNull(predicate);
            return object -> this.test(object) && predicate.test(object);
        }

        default public Predicate<A> negate() {
            return object -> !this.test(object);
        }

        public static <A> Predicate<A> not(Predicate<? super A> predicate) {
            Objects.requireNonNull(predicate);
            return predicate.negate();
        }
    }

    @FunctionalInterface
    public static interface Supplier<R> {
        public R get() throws Exception;
    }

    @FunctionalInterface
    public static interface Runnable {
        public void run() throws Exception;
    }
}

