/*
 * Decompiled with CFR 0.152.
 */
package aeonics.util;

import aeonics.data.Data;
import java.util.ArrayList;
import java.util.Locale;
import java.util.WeakHashMap;

public class StringUtils {
    private static WeakHashMap<Class<?>, String> c1 = new WeakHashMap();
    private static WeakHashMap<String, String> c2 = new WeakHashMap();
    public static final char[] defaultWordWildcards = new char[]{'+', '*'};
    public static final char[] defaultGlobalWildcards = new char[]{'#'};
    public static final char[] defaultNegators = new char[]{'!'};
    public static final char[] defaultWordDelimiters = new char[]{'.', '/'};

    private StringUtils() {
    }

    public static String[] split(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            arrayList.add(string.substring(n2, n));
            n2 = n + string2.length();
        }
        arrayList.add(string.substring(n2));
        for (n = arrayList.size() - 1; n >= 0; --n) {
            if (!((String)arrayList.get(n)).isEmpty()) continue;
            arrayList.remove(n);
        }
        return arrayList.toArray(new String[0]);
    }

    public static String substitute(String string, String string2, String ... stringArray) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        if (string2 == null || string2.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuilder.append(string, n2, n);
            if (stringArray.length > n3) {
                stringBuilder.append(stringArray[n3]);
                ++n3;
            }
            n2 = n + string2.length();
        }
        stringBuilder.append(string, n2, string.length());
        return stringBuilder.toString();
    }

    public static String substitute(String string, Data data) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        if (data == null || !data.isMap()) {
            data = Data.map();
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf("{{", n2)) != -1) {
            stringBuilder.append(string, n2, n);
            n2 = n + 2;
            n = string.indexOf("}}", n + 2);
            if (n < 0) break;
            String string2 = string.substring(n2, n);
            if (data.containsKey(string2)) {
                stringBuilder.append(data.asString(string2));
            }
            n2 = n + 2;
        }
        stringBuilder.append(string, n2, string.length());
        return stringBuilder.toString();
    }

    public static String toLowerCase(Class<?> clazz2) {
        if (clazz2 == null) {
            return "";
        }
        return c1.computeIfAbsent(clazz2, clazz -> clazz.getName().toLowerCase(Locale.ROOT));
    }

    public static String toLowerCase(String string2) {
        if (string2 == null || string2.isEmpty()) {
            return "";
        }
        return c2.computeIfAbsent(string2, string -> string.toLowerCase(Locale.ROOT));
    }

    public static boolean simplePathMatches(String string, String string2) {
        return StringUtils.simplePathMatches(string, string2, defaultWordWildcards, defaultGlobalWildcards, defaultNegators, defaultWordDelimiters);
    }

    private static boolean inArray(char[] cArray, char c) {
        for (char c2 : cArray) {
            if (c2 != c) continue;
            return true;
        }
        return false;
    }

    public static boolean simplePathMatches(String string, String string2, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        char c;
        char c2;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (string != null && string.length() > 0 && StringUtils.inArray(cArray3, string.charAt(0))) {
            n = 1;
            bl = true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == n) {
            return bl ? n4 > 0 : n4 == 0;
        }
        while (n < n3 && (StringUtils.inArray(cArray4, c2 = string.charAt(n)) || c2 == ' ')) {
            ++n;
        }
        while (n2 < n4 && (StringUtils.inArray(cArray4, c = string2.charAt(n2)) || c == ' ')) {
            ++n2;
        }
        while (n < n3 && (StringUtils.inArray(cArray4, c2 = string.charAt(n3 - 1)) || c2 == ' ')) {
            --n3;
        }
        while (n2 < n4 && (StringUtils.inArray(cArray4, c = string2.charAt(n4 - 1)) || c == ' ')) {
            --n4;
        }
        if (n3 == n) {
            return bl ? n4 > 0 : n4 == 0;
        }
        if (n3 == n4 && string.equals(string2)) {
            return !bl;
        }
        while (n < n3 && n2 < n4) {
            c2 = string.charAt(n);
            c = string2.charAt(n2);
            if (StringUtils.inArray(cArray2, c2)) {
                return !bl;
            }
            if (StringUtils.inArray(cArray, c2)) {
                while (n < n3 && !StringUtils.inArray(cArray4, c2 = string.charAt(n))) {
                    if (StringUtils.inArray(cArray2, c2)) {
                        return !bl;
                    }
                    ++n;
                }
                while (n2 < n4 && !StringUtils.inArray(cArray4, c = string2.charAt(n2))) {
                    ++n2;
                }
                --n2;
            } else if (StringUtils.inArray(cArray4, c2)) {
                if (!StringUtils.inArray(cArray4, c)) {
                    return bl;
                }
                ++n;
            } else {
                if (c != c2) {
                    return bl;
                }
                ++n;
            }
            ++n2;
        }
        if (n2 < n4) {
            return bl;
        }
        if (n < n3) {
            while (n < n3) {
                c2 = string.charAt(n);
                if (StringUtils.inArray(cArray2, c2)) {
                    return !bl;
                }
                if (StringUtils.inArray(cArray, c2)) {
                    while (n < n3 && !StringUtils.inArray(cArray4, c2 = string.charAt(n))) {
                        if (StringUtils.inArray(cArray2, c2)) {
                            return !bl;
                        }
                        ++n;
                    }
                } else {
                    return bl;
                }
                ++n;
            }
        }
        return !bl;
    }

    public static String trim(String string, char ... cArray) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = string.charAt(string.length() - i - 1);
            for (int j = 0; j < cArray.length; ++j) {
                char c3 = cArray[j];
                if (c == c3 && n == i) {
                    ++n;
                }
                if (c2 != c3 || n2 != string.length() - i) continue;
                --n2;
            }
            if (n >= n2) {
                return "";
            }
            if (n < i && n2 > string.length() - i) break;
        }
        return string.substring(n, n2);
    }

    public static String truncate(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n >= 0) {
            return string.substring(n >= string.length() ? string.length() - 1 : n);
        }
        n = string.length() + n;
        return string.substring(0, n < 0 ? 0 : n);
    }

    public static boolean contains(String string, CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            if (string.indexOf(charSequence.charAt(i)) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isComposedOf(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = string.codePointAt(i);
            boolean bl = false;
            for (int j = 0; j < string2.length(); ++j) {
                n2 = string2.codePointAt(j);
                if (n != n2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(String string) {
        return StringUtils.isDigit(string, false);
    }

    public static boolean isDigit(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = string.codePointAt(i);
            if (n >= 48 && n <= 57 || bl && n == 32) continue;
            return false;
        }
        return true;
    }

    public static boolean isInteger(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        if (string.codePointAt(0) == 45) {
            ++n2;
        }
        while (n2 < string.length()) {
            n = string.codePointAt(n2);
            if (n < 48 || n > 57) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isFloatingPoint(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (string.codePointAt(0) == 45) {
            ++n2;
        }
        while (n2 < string.length()) {
            n = string.codePointAt(n2);
            if (n == 46) {
                if (bl) {
                    return false;
                }
                bl = true;
            } else if (n < 48 || n > 57) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isLower(String string) {
        return StringUtils.isLower(string, false);
    }

    public static boolean isLower(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = string.codePointAt(i);
            if (n >= 97 && n <= 122 || bl && n == 32) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpper(String string) {
        return StringUtils.isUpper(string, false);
    }

    public static boolean isUpper(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = string.codePointAt(i);
            if (n >= 65 && n <= 90 || bl && n == 32) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String string) {
        return StringUtils.isAlpha(string, false);
    }

    public static boolean isAlpha(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = string.codePointAt(i);
            if (!(n >= 65 && n <= 122 || bl && n == 32)) {
                return false;
            }
            if (n <= 90 || n >= 97) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNum(String string) {
        return StringUtils.isAlphaNum(string, false);
    }

    public static boolean isAlphaNum(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = string.codePointAt(i);
            if (!(n >= 48 && n <= 122 || bl && n == 32)) {
                return false;
            }
            if (n > 57 && n < 65) {
                return false;
            }
            if (n <= 90 || n >= 97) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexaLower(String string) {
        return StringUtils.isHexaLower(string, 0);
    }

    public static boolean isHexaLower(String string, int n) {
        if (string == null || string.length() == 0 || n > 0 && string.length() > n) {
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n2 = string.codePointAt(i);
            if (n2 < 48 || n2 > 102) {
                return false;
            }
            if (n2 <= 57 || n2 >= 97) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexaUpper(String string) {
        return StringUtils.isHexaUpper(string, 0);
    }

    public static boolean isHexaUpper(String string, int n) {
        if (string == null || string.length() == 0 || n > 0 && string.length() > n) {
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n2 = string.codePointAt(i);
            if (n2 < 48 || n2 > 70) {
                return false;
            }
            if (n2 <= 57 || n2 >= 65) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexa(String string) {
        return StringUtils.isHexa(string, 0);
    }

    public static boolean isHexa(String string, int n) {
        if (string == null || string.length() == 0 || n > 0 && string.length() > n) {
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n2 = string.codePointAt(i);
            if (n2 < 48 || n2 > 102) {
                return false;
            }
            if (n2 > 57 && n2 < 65) {
                return false;
            }
            if (n2 <= 70 || n2 >= 97) continue;
            return false;
        }
        return true;
    }

    public static boolean isNull(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return "null".equalsIgnoreCase(string);
    }

    public static boolean isBoolean(String string) {
        return StringUtils.isBoolean(string, false);
    }

    public static boolean isBoolean(String string, boolean bl) {
        if (string == null || string.length() == 0 || string.length() > 5) {
            return false;
        }
        if (bl && ("yes".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string))) {
            return true;
        }
        return "1".equals(string) || "0".equals(string) || "true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string);
    }

    public static boolean isTrue(String string) {
        return StringUtils.isTrue(string, false);
    }

    public static boolean isTrue(String string, boolean bl) {
        if (string == null || string.length() == 0 || string.length() > 4) {
            return false;
        }
        if (bl && "yes".equalsIgnoreCase(string)) {
            return true;
        }
        return "1".equals(string) || "true".equalsIgnoreCase(string);
    }

    public static boolean isFalse(String string) {
        return StringUtils.isFalse(string, false);
    }

    public static boolean isFalse(String string, boolean bl) {
        if (string == null || string.length() == 0 || string.length() > 5) {
            return false;
        }
        if (bl && "no".equalsIgnoreCase(string)) {
            return true;
        }
        return "0".equals(string) || "false".equalsIgnoreCase(string);
    }

    public static boolean isBase64(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        block3: for (int i = 0; i < string.length(); ++i) {
            n = string.codePointAt(i);
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 43: 
                case 45: 
                case 47: 
                case 61: 
                case 95: {
                    continue block3;
                }
                default: {
                    if (n < 48 || n > 122) {
                        return false;
                    }
                    if (n > 57 && n < 65) {
                        return false;
                    }
                    if (n <= 90 || n >= 97) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEmailSimple(String string) {
        int n;
        if (string == null || string.length() == 0 || string.length() > 255) {
            return false;
        }
        int n2 = string.indexOf(64);
        if (n2 < 1 || n2 > string.length() - 3 || n2 != string.lastIndexOf(64)) {
            return false;
        }
        int n3 = 0;
        block3: for (n = 0; n < n2; ++n) {
            n3 = string.codePointAt(n);
            switch (n3) {
                case 43: 
                case 45: 
                case 46: 
                case 58: 
                case 95: {
                    continue block3;
                }
                default: {
                    if (n3 < 48 || n3 > 122) {
                        return false;
                    }
                    if (n3 > 57 && n3 < 65) {
                        return false;
                    }
                    if (n3 <= 90 || n3 >= 97) continue block3;
                    return false;
                }
            }
        }
        ++n;
        while (n < string.length() && (n3 = string.codePointAt(n)) != 46 && n3 != 45 && n3 != 95) {
            if (n3 < 48 || n3 > 122) {
                return false;
            }
            if (n3 > 57 && n3 < 65) {
                return false;
            }
            if (n3 > 90 && n3 < 97) {
                return false;
            }
            ++n;
        }
        if (string.length() - n < 2) {
            return false;
        }
        ++n;
        while (n < string.length()) {
            n3 = string.codePointAt(n);
            if ((n3 < 48 || n3 > 122) && n3 != 46 && n3 != 45) {
                return false;
            }
            if (n3 > 57 && n3 < 65) {
                return false;
            }
            if (n3 > 90 && n3 < 97 && n3 != 95) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isUrlSimple(String string) {
        if (string == null || string.length() < 10 || string.length() > 500) {
            return false;
        }
        if (!string.startsWith("http")) {
            return false;
        }
        int n = 4;
        if (string.charAt(n) == 's') {
            // empty if block
        }
        int n2 = ++n;
        ++n;
        if (string.charAt(n2) != ':') {
            return false;
        }
        if (string.charAt(n++) != '/') {
            return false;
        }
        if (string.charAt(n++) != '/') {
            return false;
        }
        if (string.charAt(n++) == '/') {
            return false;
        }
        return StringUtils.isComposedOf(string, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.~()'!*:@,;/%?#&=+");
    }

    public static boolean isPath(String string) {
        return StringUtils.isPath(string, false);
    }

    public static boolean isWildcardPath(String string) {
        return StringUtils.isPath(string, true);
    }

    public static boolean isPath(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        if (bl && string.codePointAt(0) == 33) {
            n2 = 1;
        }
        while (n2 < string.length()) {
            n = string.codePointAt(n2);
            if (n < 46 || n > 122 ? n != 45 && n != 32 && (!bl || n != 43 && n != 42 && n != 35) : (n > 57 && n < 65 ? n != 58 : n > 90 && n < 97 && n != 95)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        if (string == null || string2 == null || string.length() != string2.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            int n;
            int n2 = string.codePointAt(i);
            if (n2 == (n = string2.codePointAt(i)) || n2 >= 97 && n2 <= 122 && n2 == n + 32 || n2 >= 65 && n2 <= 90 && n2 == n - 32) continue;
            return false;
        }
        return true;
    }

    public static String toHex(byte[] byArray) {
        return StringUtils.toHexUpper(byArray);
    }

    public static String toHexLower(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.format("%02x", byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String toHexUpper(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.format("%02X", byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String substring(String string, int n, int n2) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        int n3 = string.length();
        if (n < 0) {
            n = n3 + n;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= n3) {
            return "";
        }
        if (n2 < 0) {
            n2 = n3 + n2;
        }
        if (n2 < 0) {
            return "";
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 <= n) {
            return "";
        }
        return string.substring(n, n2);
    }
}

