/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.entity.Probe;
import aeonics.manager.Config;
import aeonics.manager.Executor;
import aeonics.manager.Lifecycle;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Network;
import aeonics.manager.Timeout;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.Callback;
import aeonics.util.Functions;
import aeonics.util.Hardware;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLHandshakeException;

public class DefaultNetwork
extends Manager<Network> {
    private static final LongAdder bytesRead = new LongAdder();
    private static final LongAdder bytesWritten = new LongAdder();
    private static final LongAdder connectionsEstablished = new LongAdder();

    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Network> template() {
        return super.template().summary("Non-blocking network manager").description("This network manager will keep track of all listening and established connections in a non-blocking efficient manner and will deferprocessing of reads and writes to the Execution manager. Connections can be secured with TLS.").config(Network.class, new Parameter("timeout").summary("Default network idle timeout").description("This configuration parameter defines the priod of time in milliseconds after which an idle network connection is considered inactive ans should be forcibly closed.").rule(Parameter.Rule.DIGIT).format("number").optional(true).defaultValue((Object)120000)).onCreate((data, network) -> {
            ((Probe.Type)new Probe(){}.template().summary("Network").description("This probe returns the cumulated total number of bytes read and written on the network. It also returns the cumulated number of established connections.").create()).source(() -> Data.map().put("read", (Object)bytesRead.longValue()).put("write", (Object)bytesWritten.longValue()).put("connect", (Object)connectionsEstablished.longValue())).name("network");
            if (((Lifecycle)Manager.of(Lifecycle.class)).phase() == Lifecycle.Phase.RUN) {
                ((Implementation)network).task = ((Implementation)network).task();
            } else {
                Lifecycle.before((Lifecycle.Phase)Lifecycle.Phase.RUN, (Callback.Once)Callback.once(() -> {
                    ((Implementation)network).task = ((Implementation)network).task();
                }));
            }
        });
    }

    private static class TLS_Buffer
    implements AutoCloseable,
    Supplier<ByteBuffer> {
        private static final int BUFFER_SIZE = 65536;
        private long idle = System.currentTimeMillis();
        private ByteBuffer buffer;

        public TLS_Buffer() {
            Hardware.RAM.waitForSpace((long)65536L, (long)1000L);
            this.buffer = ByteBuffer.allocate(65536);
        }

        @Override
        public ByteBuffer get() {
            return this.buffer;
        }

        @Override
        public void close() {
            this.idle = System.currentTimeMillis();
            TLS_BufferPool.offer(this);
        }
    }

    private static class TLS_BufferPool {
        private static Deque<TLS_Buffer> pool = new ConcurrentLinkedDeque<TLS_Buffer>();
        private static AtomicBoolean initialized = new AtomicBoolean(false);
        private static Timeout.Tracker<Void> tracker = new Timeout.Tracker<Void>(null){
            private long max = 60000000L;

            public long delay() {
                if (pool.isEmpty()) {
                    return this.max;
                }
                Iterator<TLS_Buffer> iterator = pool.descendingIterator();
                while (iterator.hasNext()) {
                    TLS_Buffer tLS_Buffer = iterator.next();
                    if (tLS_Buffer == null) continue;
                    if (System.currentTimeMillis() - tLS_Buffer.idle >= this.max) {
                        iterator.remove();
                        continue;
                    }
                    return Math.max(1L, tLS_Buffer.idle + this.max - System.currentTimeMillis());
                }
                return this.max;
            }
        };

        private TLS_BufferPool() {
        }

        static void offer(TLS_Buffer tLS_Buffer) {
            tLS_Buffer.get().clear();
            pool.offerFirst(tLS_Buffer);
        }

        static TLS_Buffer poll() {
            TLS_Buffer tLS_Buffer;
            if (initialized.compareAndSet(false, true)) {
                ((Timeout)Manager.of(Timeout.class)).watch(tracker);
            }
            if ((tLS_Buffer = pool.pollFirst()) == null) {
                return new TLS_Buffer();
            }
            tLS_Buffer.idle = System.currentTimeMillis();
            return tLS_Buffer;
        }
    }

    private static class ServerImplementation
    implements Network.Server {
        private Callback<Network.Connection, Network.Server> onAccept = new Callback((Object)this);
        private Callback<Void, Network.Server> onClose = new Callback((Object)this);
        private AtomicReference<ServerSocketChannel> channel = new AtomicReference();
        private Network.SecurityOptions security = null;

        public ServerImplementation(ServerSocketChannel serverSocketChannel, Network.SecurityOptions securityOptions) {
            this.channel.set(serverSocketChannel);
            this.security = securityOptions;
        }

        public void close() throws IOException {
            try {
                SelectableChannel selectableChannel = this.channel.getAndSet(null);
                if (selectableChannel != null) {
                    selectableChannel.close();
                }
            }
            finally {
                this.onClose().trigger();
            }
        }

        public Callback<Network.Connection, Network.Server> onAccept() {
            return this.onAccept;
        }

        public Callback<Void, Network.Server> onClose() {
            return this.onClose;
        }

        public ServerSocketChannel channel() {
            return this.channel.get();
        }

        public Network.SecurityOptions security() {
            return this.security;
        }

        public boolean isSecure() {
            return this.security() != null;
        }
    }

    private static class SecureConnectionImplementation
    implements Network.Connection {
        private ConcurrentLinkedQueue<byte[]> fifo = new ConcurrentLinkedQueue();
        private Network.Connection source;
        private SSLEngine ssl;
        private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
        AtomicBoolean handshakeComplete = new AtomicBoolean(false);
        private final ConcurrentLinkedQueue<ByteBuffer> writeBuffer = new ConcurrentLinkedQueue();
        private Callback<Void, Network.Connection> onReady = new Callback((Object)this);
        AtomicBoolean reading = new AtomicBoolean(false);
        TLS_Buffer encrypted = null;
        private final ReentrantLock writing = new ReentrantLock(true);

        public SecureConnectionImplementation(Network.Connection connection2, Network.SecurityOptions securityOptions) {
            this.source = connection2;
            this.source.onClose().then((Functions.BiConsumer)Callback.once((void_, connection) -> this.onClose().trigger()));
            this.source.onReady().then((void_, connection) -> this.read());
            this.ssl = Network.sslEngine((Network.SecurityOptions)securityOptions, (boolean)connection2.isClientMode());
            if (connection2.isClientMode()) {
                try {
                    this.handshake(null);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        private void handshake(ByteBuffer byteBuffer) throws Exception {
            SSLEngineResult sSLEngineResult = null;
            block12: while (true) {
                SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult == null ? this.ssl.getHandshakeStatus() : sSLEngineResult.getHandshakeStatus();
                switch (handshakeStatus) {
                    case NOT_HANDSHAKING: {
                        if (byteBuffer != null && sSLEngineResult == null) {
                            sSLEngineResult = this.ssl.unwrap(byteBuffer, EMPTY);
                            break;
                        }
                    }
                    case FINISHED: {
                        if (this.ssl.getSession() == null) {
                            throw new SSLHandshakeException("Handshake failed");
                        }
                        if (this.ssl.getSession().isValid()) {
                            this.ssl.getSession().invalidate();
                        }
                        this.handshakeComplete.set(true);
                        if (this.reading.get()) {
                            this.read3();
                        } else {
                            this.read();
                        }
                        ((Executor)Manager.of(Executor.class)).normal(this::processBufferedWrites);
                        return;
                    }
                    case NEED_TASK: {
                        Object object;
                        while ((object = this.ssl.getDelegatedTask()) != null) {
                            object.run();
                        }
                        sSLEngineResult = null;
                        break;
                    }
                    case NEED_WRAP: {
                        Object object = TLS_BufferPool.poll();
                        try {
                            sSLEngineResult = this.ssl.wrap(EMPTY, ((TLS_Buffer)object).get());
                            this.source.write(((TLS_Buffer)object).get().flip());
                            continue block12;
                        }
                        finally {
                            if (object == null) continue block12;
                            ((TLS_Buffer)object).close();
                            continue block12;
                        }
                    }
                    case NEED_UNWRAP: 
                    case NEED_UNWRAP_AGAIN: {
                        if (byteBuffer == null || !byteBuffer.hasRemaining()) break block12;
                        int n = byteBuffer.position();
                        sSLEngineResult = this.ssl.unwrap(byteBuffer, EMPTY);
                        if (n != byteBuffer.position() || !byteBuffer.hasRemaining()) continue block12;
                        break block12;
                    }
                    default: {
                        throw new SSLHandshakeException("Unsupported handshake status: " + this.ssl.getHandshakeStatus());
                    }
                }
            }
        }

        private void processBufferedWrites() {
            while (this.handshakeComplete.get()) {
                ByteBuffer byteBuffer = this.writeBuffer.poll();
                if (byteBuffer == null) {
                    return;
                }
                this.write(byteBuffer);
            }
        }

        public void close() throws IOException {
            this.source.close();
        }

        public boolean isSecure() {
            return true;
        }

        public boolean isClientMode() {
            return this.source.isClientMode();
        }

        public Callback<Void, Network.Connection> onReady() {
            return this.onReady;
        }

        public byte[] next() {
            return this.fifo.poll();
        }

        public boolean hasNext() {
            return !this.fifo.isEmpty();
        }

        private void read() {
            while (this.source.hasNext()) {
                if (!this.reading.compareAndSet(false, true)) {
                    return;
                }
                try {
                    this.read2();
                }
                catch (SSLHandshakeException sSLHandshakeException) {
                    ((Logger)Manager.of(Logger.class)).finest(Network.class, "Handshake failed. {}", new Object[]{sSLHandshakeException.getMessage()});
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).fine(Network.class, (Throwable)exception);
                    try {
                        this.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                finally {
                    this.reading.set(false);
                }
            }
        }

        private void read2() throws Exception {
            byte[] byArray = this.source.next();
            while (byArray != null) {
                if (this.encrypted == null) {
                    this.encrypted = TLS_BufferPool.poll();
                }
                boolean bl = false;
                int n = 0;
                do {
                    int n2 = this.encrypted.get().remaining();
                    int n3 = Math.min(n2, byArray.length - n);
                    this.encrypted.get().put(byArray, n, n3);
                    bl = (n += n3) < byArray.length;
                    this.encrypted.get().flip();
                    if (!this.read3()) {
                        this.encrypted.close();
                        return;
                    }
                    this.encrypted.get().compact();
                } while (bl);
                byArray = this.source.next();
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean read3() throws Exception {
            if (!this.handshakeComplete.get()) {
                this.handshake(this.encrypted.get());
                return true;
            }
            var1_1 = false;
            while (this.encrypted.get().hasRemaining()) {
                var1_1 = false;
                var2_2 = TLS_BufferPool.poll();
                try {
                    var3_3 = this.ssl.unwrap(this.encrypted.get(), var2_2.get());
                    switch (2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[var3_3.getHandshakeStatus().ordinal()]) {
                        case 3: {
                            while ((var4_5 = this.ssl.getDelegatedTask()) != null) {
                                var4_5.run();
                            }
                        }
                        case 4: {
                            var4_5 = TLS_BufferPool.poll();
                            try {
                                var3_3 = this.ssl.wrap(SecureConnectionImplementation.EMPTY, var4_5.get());
                                this.source.write(var4_5.get().flip());
                                if (var4_5 == null) break;
                                var4_5.close();
                                break;
                            }
                            catch (Throwable var5_8) {
                                if (var4_5 != null) {
                                    try {
                                        var4_5.close();
                                    }
                                    catch (Throwable var6_9) {
                                        var5_8.addSuppressed(var6_9);
                                    }
                                }
                                throw var5_8;
                            }
                        }
                    }
                    switch (2.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[var3_3.getStatus().ordinal()]) {
                        case 1: {
                            ** break;
lbl34:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            var1_1 = true;
                            var2_2.get().flip();
                            if (var2_2.get().hasRemaining()) {
                                var4_5 = new byte[var2_2.get().remaining()];
                                var2_2.get().get((byte[])var4_5);
                                this.fifo.offer((byte[])var4_5);
                            }
                            var2_2.get().clear();
                            ((Executor)Manager.of(Executor.class)).normal((Functions.Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$read3$2(), ()V)((SecureConnectionImplementation)this));
                            ** break;
lbl50:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            throw new IllegalStateException("Unexpected large frame size");
                        }
                        default: {
                            var4_6 = false;
                            return var4_6;
                        }
                    }
                }
                finally {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                }
                if (var1_1) continue;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(ByteBuffer var1_1) {
            this.writing.lock();
lbl2:
            // 2 sources

            try {
                while (var1_1.hasRemaining()) {
                    if (!this.handshakeComplete.get()) {
                        this.writeBuffer.add(var1_1);
                        return;
                    }
                    try {
                        var2_2 = TLS_BufferPool.poll();
                        try {
                            var3_4 = var2_2.get();
                            var4_6 = this.ssl.wrap(var1_1, var3_4);
                            if (var4_6.getStatus() != SSLEngineResult.Status.OK) {
                                throw new IllegalStateException("Invalid SSLEngine state in wrap : " + var4_6.getStatus());
                            }
                            this.source.write(var3_4.flip());
                            if (var4_6.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED || var4_6.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
                            this.handshakeComplete.set(false);
                            this.handshake(null);
                        }
                        finally {
                            if (var2_2 == null) ** GOTO lbl2
                            var2_2.close();
                        }
                    }
                    catch (Exception var2_3) {
                        throw new RuntimeException(var2_3);
                        return;
                    }
                }
            }
            finally {
                this.writing.unlock();
            }
        }

        public Callback<Void, Network.Connection> onClose() {
            return this.source.onClose();
        }

        public void timeout(long l) {
            this.source.timeout(l);
        }

        public String clientIp() {
            return this.source.clientIp();
        }

        public String serverIp() {
            return this.source.serverIp();
        }

        public String alpn() {
            if (this.ssl == null) {
                return "";
            }
            return Objects.requireNonNullElse(this.ssl.getApplicationProtocol(), "");
        }

        public String sni() {
            if (this.ssl == null) {
                return "";
            }
            if (this.ssl.getSession() instanceof ExtendedSSLSession) {
                List<SNIServerName> list = ((ExtendedSSLSession)this.ssl.getSession()).getRequestedServerNames();
                if (list == null || list.isEmpty()) {
                    return "";
                }
                for (SNIServerName sNIServerName : list) {
                    if (!(sNIServerName instanceof SNIHostName)) continue;
                    return ((SNIHostName)sNIServerName).getAsciiName();
                }
            }
            return "";
        }

        public boolean active() {
            return this.source.active();
        }

        public String toString() {
            if (this.source == null) {
                return super.toString();
            }
            return this.source.toString();
        }

        private /* synthetic */ void lambda$read3$2() throws Exception {
            this.onReady().trigger();
        }
    }

    private static class ConnectionImplementation
    implements Network.Connection {
        ConcurrentLinkedQueue<byte[]> fifo = new ConcurrentLinkedQueue();
        private CountDownLatch connected = new CountDownLatch(1);
        private AtomicBoolean closed = new AtomicBoolean(false);
        private Callback<Void, Network.Connection> onReady = new Callback((Object)this);
        private Callback<Void, Network.Connection> onClose = new Callback((Object)this);
        private AtomicReference<SocketChannel> channel = new AtomicReference();
        private boolean clientMode;
        private volatile long lastActivity = System.currentTimeMillis();
        private long ttl = ((Config)Manager.of(Config.class)).get(Network.class, "timeout").asLong();
        private Timeout.Tracker<ConnectionImplementation> tracker = null;

        public ConnectionImplementation(SocketChannel socketChannel, boolean bl) {
            this.channel.set(socketChannel);
            this.clientMode = bl;
            this.setupTracker();
        }

        public void close() throws IOException {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            try {
                this.closed.set(true);
                SelectableChannel selectableChannel = this.channel.getAndSet(null);
                if (selectableChannel != null) {
                    selectableChannel.close();
                }
            }
            finally {
                ((Timeout)Manager.of(Timeout.class)).remove(this.tracker);
                this.onClose().trigger();
            }
        }

        public Callback<Void, Network.Connection> onReady() {
            return this.onReady;
        }

        public byte[] next() {
            return this.fifo.poll();
        }

        public boolean hasNext() {
            return !this.fifo.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ByteBuffer byteBuffer) {
            try {
                if (this.closed.get()) {
                    throw new IOException("Connection closed");
                }
                try {
                    while (!this.closed.get() && !this.connected.await(1L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                if (this.closed.get()) {
                    throw new IOException("Connection closed");
                }
                SocketChannel socketChannel = this.channel();
                if (socketChannel == null) {
                    throw new IllegalStateException("Connection is not established");
                }
                SocketChannel socketChannel2 = socketChannel;
                synchronized (socketChannel2) {
                    int n = 0;
                    while (byteBuffer.hasRemaining()) {
                        n = socketChannel.write(byteBuffer);
                        if (n == 0) {
                            LockSupport.parkNanos(1000000L);
                            continue;
                        }
                        bytesWritten.add(n);
                        this.resetTimeout();
                    }
                }
            }
            catch (IOException iOException) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new RuntimeException(iOException);
            }
        }

        public Callback<Void, Network.Connection> onClose() {
            return this.onClose;
        }

        public SocketChannel channel() {
            return this.channel.get();
        }

        public boolean isClientMode() {
            return this.clientMode;
        }

        public boolean isSecure() {
            return false;
        }

        public void timeout(long l) {
            this.ttl = Math.max(l, 10L);
        }

        public String clientIp() {
            try {
                if (this.isClientMode()) {
                    return ((InetSocketAddress)this.channel.get().getLocalAddress()).getAddress().getHostAddress();
                }
                return ((InetSocketAddress)this.channel.get().getRemoteAddress()).getAddress().getHostAddress();
            }
            catch (Exception exception) {
                return "undefined";
            }
        }

        public String serverIp() {
            try {
                if (this.isServerMode()) {
                    return ((InetSocketAddress)this.channel.get().getLocalAddress()).getAddress().getHostAddress();
                }
                return ((InetSocketAddress)this.channel.get().getRemoteAddress()).getAddress().getHostAddress();
            }
            catch (Exception exception) {
                return "undefined";
            }
        }

        public String alpn() {
            return "";
        }

        public String sni() {
            return "";
        }

        public boolean active() {
            return !this.closed.get();
        }

        public String toString() {
            try {
                SocketChannel socketChannel = this.channel.get();
                if (socketChannel == null) {
                    return "Unbounded " + (this.isClientMode() ? "client" : "server") + " connection " + this.hashCode();
                }
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketChannel.getLocalAddress();
                InetSocketAddress inetSocketAddress2 = (InetSocketAddress)socketChannel.getRemoteAddress();
                if (inetSocketAddress == null || inetSocketAddress2 == null) {
                    return "Unbounded " + (this.isClientMode() ? "client" : "server") + " connection " + this.hashCode();
                }
                if (this.isClientMode()) {
                    return "[" + inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort() + " --OUT--> " + inetSocketAddress2.getAddress().getHostAddress() + ":" + inetSocketAddress2.getPort() + "]";
                }
                return "[" + inetSocketAddress2.getAddress().getHostAddress() + ":" + inetSocketAddress2.getPort() + " --IN--> " + inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort() + "]";
            }
            catch (Exception exception) {
                return "Unsettled " + (this.isClientMode() ? "client" : "server") + " connection " + this.hashCode();
            }
        }

        public void resetTimeout() {
            this.lastActivity = System.currentTimeMillis();
        }

        private void setupTracker() {
            this.tracker = new Timeout.Tracker<ConnectionImplementation>(this){

                public long delay() {
                    if (closed.get()) {
                        return -1L;
                    }
                    return Math.max(0L, lastActivity + ttl - System.currentTimeMillis());
                }
            };
            this.tracker.onExpire().then((connectionImplementation, tracker) -> {
                SocketChannel socketChannel = connectionImplementation.channel();
                try {
                    String string = ((InetSocketAddress)socketChannel.getLocalAddress()).getAddress().getHostAddress();
                    int n = ((InetSocketAddress)socketChannel.getLocalAddress()).getPort();
                    String string2 = ((InetSocketAddress)socketChannel.getRemoteAddress()).getAddress().getHostAddress();
                    int n2 = ((InetSocketAddress)socketChannel.getRemoteAddress()).getPort();
                    if (this.isClientMode()) {
                        ((Logger)Manager.of(Logger.class)).fine(Network.class, "Timeout for connection {}:{} -> {}:{}", new Object[]{string, n, string2, n2});
                    } else {
                        ((Logger)Manager.of(Logger.class)).fine(Network.class, "Timeout for connection {}:{} -> {}:{}", new Object[]{string2, n2, string, n});
                    }
                    connectionImplementation.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            ((Timeout)Manager.of(Timeout.class)).watch(this.tracker);
        }
    }

    private static class Implementation
    extends Network
    implements Closeable {
        private Selector selector;
        private final CountDownLatch initialized = new CountDownLatch(1);
        private Executor.Task<Void> task = null;

        private Implementation() {
        }

        public Network.Connection client(String string, int n, Network.SecurityOptions securityOptions) throws IOException {
            try {
                this.initialized.await();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            SocketChannel socketChannel = null;
            try {
                socketChannel = SocketChannel.open();
                try {
                    socketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).finest(Network.class, "Socket option SO_REUSEADDR could not be set for {}:{}", new Object[]{string, n});
                }
                socketChannel.configureBlocking(false);
                ConnectionImplementation connectionImplementation = new ConnectionImplementation(socketChannel, true);
                socketChannel.register(this.selector, 8, connectionImplementation);
                this.selector.wakeup();
                if (socketChannel.connect(new InetSocketAddress(string, n))) {
                    this.onConnectable2(connectionImplementation);
                }
                return securityOptions == null ? connectionImplementation : this.securize(connectionImplementation, securityOptions);
            }
            catch (IOException iOException) {
                socketChannel.close();
                ((Logger)Manager.of(Logger.class)).info(Network.class, (Throwable)iOException);
                throw iOException;
            }
        }

        public Network.Server server(String string, int n, Network.SecurityOptions securityOptions) throws IOException {
            try {
                this.initialized.await();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            ServerSocketChannel serverSocketChannel = null;
            try {
                serverSocketChannel = ServerSocketChannel.open();
                try {
                    serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).finest(Network.class, "Socket option SO_REUSEADDR could not be set for {}:{}", new Object[]{string, n});
                }
                try {
                    serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEPORT, (Object)true);
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).finest(Network.class, "Socket option SO_REUSEPORT could not be set for {}:{}", new Object[]{string, n});
                }
                serverSocketChannel.bind(new InetSocketAddress(string, n), ((Config)Manager.of(Config.class)).get(Network.class, "backlog").asInt());
                serverSocketChannel.configureBlocking(false);
                ServerImplementation serverImplementation = new ServerImplementation(serverSocketChannel, securityOptions);
                serverSocketChannel.register(this.selector, 16, serverImplementation);
                this.selector.wakeup();
                ((Logger)Manager.of(Logger.class)).config(Network.class, "Server listening on {}:{}", new Object[]{string, n});
                return serverImplementation;
            }
            catch (IOException iOException) {
                ((Logger)Manager.of(Logger.class)).info(Network.class, (Throwable)iOException);
                serverSocketChannel.close();
                throw iOException;
            }
        }

        public Network.Connection securize(Network.Connection connection, Network.SecurityOptions securityOptions) {
            if (securityOptions == null || connection.isSecure()) {
                return connection;
            }
            return new SecureConnectionImplementation(connection, securityOptions);
        }

        public void refresh() {
            if (this.initialized.getCount() == 0L) {
                this.selector.wakeup();
            }
        }

        @Override
        public void close() {
            this.task.cancel();
        }

        private void onAcceptable(SelectionKey selectionKey) throws Exception {
            SocketChannel socketChannel;
            if (!(selectionKey.attachment() instanceof ServerImplementation)) {
                throw new IllegalStateException("Invalid attachment on acceptable selection key");
            }
            ServerImplementation serverImplementation = (ServerImplementation)selectionKey.attachment();
            ServerSocketChannel serverSocketChannel = serverImplementation.channel();
            while ((socketChannel = serverSocketChannel.accept()) != null) {
                connectionsEstablished.increment();
                socketChannel.configureBlocking(false);
                ConnectionImplementation connectionImplementation = new ConnectionImplementation(socketChannel, false);
                Network.Connection connection = serverImplementation.isSecure() ? this.securize(connectionImplementation, serverImplementation.security()) : null;
                ((Executor)Manager.of(Executor.class)).io(() -> serverImplementation.onAccept().trigger((Object)(connection == null ? connectionImplementation : connection))).then(() -> this.onConnectable2(connectionImplementation));
            }
        }

        private void onConnectable(SelectionKey selectionKey) throws Exception {
            if (!(selectionKey.attachment() instanceof ConnectionImplementation)) {
                throw new IllegalStateException("Invalid attachment on connectable selection key");
            }
            selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFF7);
            ConnectionImplementation connectionImplementation = (ConnectionImplementation)selectionKey.attachment();
            connectionsEstablished.increment();
            this.onConnectable2(connectionImplementation);
        }

        private void onConnectable2(ConnectionImplementation connectionImplementation) {
            try {
                SocketChannel socketChannel = connectionImplementation.channel();
                if (socketChannel.isConnectionPending()) {
                    socketChannel.finishConnect();
                }
                if (!socketChannel.isConnected()) {
                    throw new RuntimeException("Connection reset before complete.");
                }
                String string = ((InetSocketAddress)socketChannel.getLocalAddress()).getAddress().getHostAddress();
                int n = ((InetSocketAddress)socketChannel.getLocalAddress()).getPort();
                String string2 = ((InetSocketAddress)socketChannel.getRemoteAddress()).getAddress().getHostAddress();
                int n2 = ((InetSocketAddress)socketChannel.getRemoteAddress()).getPort();
                try {
                    socketChannel.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)1);
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).finest(Network.class, "Socket option SO_LINGER could not be set for {}:{} - {}:{}", new Object[]{string, n, string2, n2});
                }
                try {
                    socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).finest(Network.class, "Socket option SO_KEEPALIVE could not be set for {}:{} - {}:{}", new Object[]{string, n, string2, n2});
                }
                ((Logger)Manager.of(Logger.class)).finer(Network.class, "Connection established between {}:{} and {}:{}", new Object[]{string, n, string2, n2});
                connectionImplementation.connected.countDown();
                SelectionKey selectionKey = socketChannel.register(this.selector, 1, connectionImplementation);
                this.selector.wakeup();
                this.onReadable2(connectionImplementation, selectionKey);
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).info(Network.class, (Throwable)exception);
                try {
                    connectionImplementation.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                while (connectionImplementation.connected.getCount() > 0L) {
                    connectionImplementation.connected.countDown();
                }
            }
        }

        private void onReadable(SelectionKey selectionKey) throws Exception {
            if (!(selectionKey.attachment() instanceof ConnectionImplementation)) {
                throw new IllegalStateException("Invalid attachment on readable selection key");
            }
            ConnectionImplementation connectionImplementation = (ConnectionImplementation)selectionKey.attachment();
            this.onReadable2(connectionImplementation, selectionKey);
        }

        private void onReadable2(ConnectionImplementation connectionImplementation, SelectionKey selectionKey) {
            SocketChannel socketChannel = connectionImplementation.channel();
            if (socketChannel == null || !socketChannel.isConnected()) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            try (TLS_Buffer tLS_Buffer = TLS_BufferPool.poll();){
                ByteBuffer byteBuffer = tLS_Buffer.get();
                do {
                    int n = 0;
                    try {
                        while ((n = socketChannel.read(byteBuffer)) > 0) {
                        }
                    }
                    catch (Exception exception) {
                        ((Logger)Manager.of(Logger.class)).finest(Network.class, (Throwable)exception);
                        n = -1;
                    }
                    boolean bl3 = bl2 = byteBuffer.remaining() == 0;
                    if (byteBuffer.position() > 0) {
                        byteBuffer.flip();
                        Hardware.RAM.waitForSpace((long)byteBuffer.limit(), (long)0L);
                        byte[] byArray = new byte[byteBuffer.limit()];
                        byteBuffer.get(byArray);
                        bytesRead.add(byArray.length);
                        connectionImplementation.fifo.offer(byArray);
                        connectionImplementation.resetTimeout();
                        byteBuffer.clear();
                        bl = true;
                    }
                    if (n != -1) continue;
                    selectionKey.cancel();
                } while (bl2);
            }
            if (bl) {
                ((Executor)Manager.of(Executor.class)).normal(() -> connectionImplementation.onReady().trigger());
            }
        }

        private void onSelect(SelectionKey selectionKey) {
            block14: {
                try {
                    if (selectionKey == null) {
                        throw new IllegalStateException("Channel selection key is null");
                    }
                    if (!selectionKey.isValid()) {
                        if (selectionKey.attachment() instanceof Closeable) {
                            try {
                                ((Closeable)selectionKey.attachment()).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        selectionKey.attach(null);
                        selectionKey.cancel();
                        break block14;
                    }
                    if (selectionKey.isAcceptable()) {
                        this.onAcceptable(selectionKey);
                        break block14;
                    }
                    if (selectionKey.isConnectable()) {
                        this.onConnectable(selectionKey);
                        break block14;
                    }
                    if (selectionKey.isReadable()) {
                        this.onReadable(selectionKey);
                        break block14;
                    }
                    throw new IllegalStateException("Invalid selection key operation");
                }
                catch (Exception exception) {
                    if (selectionKey == null) {
                        return;
                    }
                    ((Logger)Manager.of(Logger.class)).finer(Network.class, (Throwable)exception);
                    if (selectionKey.attachment() instanceof Closeable) {
                        try {
                            ((Closeable)selectionKey.attachment()).close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    selectionKey.attach(null);
                    selectionKey.cancel();
                }
            }
        }

        private Executor.Task<Void> task() {
            return ((Executor)Manager.of(Executor.class)).background(() -> {
                Thread.currentThread().setName(Thread.currentThread().getName() + " :: Network Manager");
                try {
                    this.selector = Selector.open();
                    this.initialized.countDown();
                    while (!Thread.currentThread().isInterrupted()) {
                        this.selector.select(this::onSelect);
                    }
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).severe(Network.class, (Throwable)exception);
                }
                finally {
                    if (this.selector != null) {
                        try {
                            for (SelectionKey selectionKey : this.selector.keys()) {
                                selectionKey.cancel();
                                try {
                                    selectionKey.channel().close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            this.selector.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }
}

